/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.exprcomp;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.base.exprcomp.GotoOp;
import filenet.vw.base.exprcomp.IField;
import filenet.vw.base.exprcomp.IFieldCollection;
import filenet.vw.base.exprcomp.IdentOp;
import filenet.vw.base.exprcomp.IfOp;
import filenet.vw.base.exprcomp.OpCode;
import filenet.vw.base.exprcomp.TraceStack;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class VWCompiledExpr {
    private Vector opCodes = new Vector();
    private int ip = 0;
    private int numOps = 0;
    private boolean debugFlag = false;
    private PrintStream os = null;
    private Stack runStack = new Stack();
    private String expr = null;
    private int exprResultType = 0;
    private boolean exprIsArray = false;
    private boolean needsFields = false;
    private boolean needsAltFields = false;

    public Object execute(IFieldCollection mainFields, IFieldCollection alternateFields, Hashtable envData) throws VWException {
        if (this.exprResultType == 0) {
            throw new VWException("vw.base.ExpressionExecution.NotCompiled", "Expression has not been compiled correctly.");
        }
        if (this.needsFields && mainFields == null) {
            throw new VWException("vw.base.ExpressionExecution.MissingFields", "Expression needs field collection.");
        }
        if (this.needsAltFields && alternateFields == null) {
            throw new VWException("vw.base.ExpressionExecution.MissingAltFields", "Expression needs alternate field collection.");
        }
        this.runStack.clear();
        this.ip = 0;
        int nextOp = 0;
        try {
            if (!this.debugFlag) {
                while (this.ip < this.numOps) {
                    if ((nextOp = ((OpCode)this.opCodes.elementAt(this.ip++)).dispatch(this.runStack, mainFields, alternateFields, envData)) == -1) continue;
                    this.ip = nextOp;
                }
            } else {
                this.os.println("=== Executing expression : >>> " + this.expr + " <<<");
                while (this.ip < this.numOps) {
                    this.os.println(" " + ((OpCode)this.opCodes.elementAt(this.ip)).toString());
                    nextOp = ((OpCode)this.opCodes.elementAt(this.ip++)).dispatch(this.runStack, mainFields, alternateFields, envData);
                    this.os.println(" ===");
                    if (nextOp == -1) continue;
                    this.ip = nextOp;
                }
            }
            if (this instanceof VWCompiledRefExpr) {
                if (this.runStack.size() != 2 && this.runStack.size() != 3) {
                    throw new VWException("vw.base.ExpressionExecution.BadStackResult", "Bad stack result, final stack depth is {0}, it should be {1} for an {2}.", String.valueOf(this.runStack.size()), String.valueOf(2), "LValue");
                }
                if (!((VWCompiledRefExpr)this).getIsIndexed()) {
                    return null;
                }
            } else if (this.runStack.size() != 1) {
                throw new VWException("vw.base.ExpressionExecution.BadStackResult", "Bad stack result, final stack depth is {0}, it should be {1}.", String.valueOf(this.runStack.size()), String.valueOf(1), "RValue");
            }
        }
        catch (Exception e) {
            if (this.debugFlag) {
                throw new VWException("vw.base.ExpressionExecution.RunTimeErrorWithDump", "Expression Execution error: {0}, \n{1}", e.getLocalizedMessage(), this.dumpState(mainFields, alternateFields, envData));
            }
            throw new VWException("vw.base.ExpressionExecution.RunTimeError", "Expression Execution error: {0}", e.getLocalizedMessage());
        }
        return this.runStack.pop();
    }

    public int getResultType() {
        return this.exprResultType;
    }

    public boolean getResultIsArray() {
        return this.exprIsArray;
    }

    public boolean isValid() {
        return this.exprResultType != 0;
    }

    public String getExpr() {
        return this.expr;
    }

    public void strip() {
        this.opCodes.trimToSize();
    }

    public void debug(boolean debug, PrintStream debugOut) {
        if (debug) {
            this.os = debugOut == null ? System.out : debugOut;
            this.runStack = new TraceStack(this.os);
        } else {
            this.os = null;
            this.runStack = new Stack();
        }
        this.debugFlag = debug;
    }

    public String toString() {
        Enumeration opE = this.opCodes.elements();
        StringBuffer retStrB = new StringBuffer("{");
        while (opE.hasMoreElements()) {
            retStrB.append(opE.nextElement().toString());
            if (!opE.hasMoreElements()) continue;
            retStrB.append(",");
        }
        retStrB.append("}");
        return retStrB.toString();
    }

    protected String dumpState(IFieldCollection mainF, IFieldCollection altF, Hashtable envD) {
        StringBuffer ret = new StringBuffer();
        try {
            IField nextF;
            ret.append("*Original Expression :\n");
            ret.append("   " + this.expr + "\n");
            ret.append("*Op Codes :\n");
            ret.append("   " + this.toString() + "\n");
            ret.append("*IP : " + String.valueOf(this.ip) + "\n");
            ret.append("*Run Stack (top first):\n");
            if (this.runStack.size() == 0) {
                ret.append(" <empty>\n");
            } else {
                for (int i = this.runStack.size() - 1; i >= 0; --i) {
                    ret.append(" (" + this.runStack.elementAt(i).toString() + ") {" + this.runStack.elementAt(i).getClass().toString() + "}\n");
                }
            }
            if (mainF != null) {
                ret.append("*Main Fields :\n");
                Enumeration flds = mainF.getFields();
                while (flds.hasMoreElements()) {
                    nextF = (IField)flds.nextElement();
                    ret.append(nextF.getName() + " " + VWFieldType.getLocalizedString(nextF.getFieldType()));
                    if (nextF.isArray()) {
                        ret.append("[" + ((Object[])nextF.getValue()).length + "]");
                    } else {
                        ret.append("  (" + nextF.getValue() + ") ");
                    }
                    ret.append(" {" + nextF.getValue().getClass().toString() + "}\n");
                }
            }
            if (altF != null) {
                ret.append("*Alternate Fields :\n");
                Enumeration flds = altF.getFields();
                while (flds.hasMoreElements()) {
                    nextF = (IField)flds.nextElement();
                    ret.append(nextF.getName() + " " + VWFieldType.getLocalizedString(nextF.getFieldType()));
                    if (nextF.isArray()) {
                        ret.append("[" + ((Object[])nextF.getValue()).length + "]");
                    } else {
                        ret.append("  (" + nextF.getValue() + ") ");
                    }
                    ret.append(" {" + nextF.getValue().getClass().toString() + "}\n");
                }
            }
            if (envD != null) {
                ret.append("*Environment Data :\n");
                Enumeration keys = envD.keys();
                while (keys.hasMoreElements()) {
                    String nextKey = (String)keys.nextElement();
                    Object value = envD.get(nextKey);
                    ret.append(nextKey + " = " + value.toString() + " {" + value.getClass().toString() + "}\n");
                }
            }
            ret.append("\n");
            return ret.toString();
        }
        catch (Exception e) {
            return ret.toString() + "\n CAUGHT EXCEPTION WHILE DUMPING INTERNAL STATE :" + e.getMessage();
        }
    }

    protected void add(OpCode newOpCode) {
        this.opCodes.addElement(newOpCode);
        ++this.numOps;
    }

    protected void setExpr(String theExpr) {
        this.expr = theExpr;
    }

    protected void setResultype(int theResultType) {
        this.exprResultType = theResultType;
    }

    protected void setResultIsArray(boolean theResultIsArray) {
        this.exprIsArray = theResultIsArray;
    }

    protected void setNeedsFields(boolean theNeedsFields) {
        this.needsFields = theNeedsFields;
    }

    protected void setNeedsAltFields(boolean theNeedsAltFields) {
        this.needsAltFields = theNeedsAltFields;
    }

    protected boolean checkNeedsFields(boolean lookingForAltField) {
        Enumeration opE = this.opCodes.elements();
        while (opE.hasMoreElements()) {
            OpCode currOp = (OpCode)opE.nextElement();
            if (!(currOp instanceof IdentOp) || ((IdentOp)currOp).isAlt() != lookingForAltField) continue;
            return true;
        }
        return false;
    }

    protected void fixupJmp(int offset) throws VWException {
        if (offset < 0 || offset > this.opCodes.size()) {
            throw new VWException("vw.base.ExpressionCompilation.BadFixupOffset", "Attempt to fixup invalid instruction offset, {0}", String.valueOf(offset));
        }
        if (this.opCodes.elementAt(offset) instanceof IfOp) {
            ((IfOp)this.opCodes.elementAt(offset)).setOffset(this.opCodes.size());
        } else if (this.opCodes.elementAt(offset) instanceof GotoOp) {
            ((GotoOp)this.opCodes.elementAt(offset)).setOffset(this.opCodes.size());
        } else {
            throw new VWException("vw.base.ExpressionCompilation.BadFixupOpCode", "Attempt to fixup a jump in a {0} opcode", this.opCodes.elementAt(offset).getClass().toString());
        }
    }

    protected int opCount() {
        return this.numOps;
    }

    protected OpCode getOpAt(int index) {
        return (OpCode)this.opCodes.elementAt(index);
    }

    protected void trim() {
        this.opCodes.trimToSize();
    }
}

